/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.util.List;
import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSItemMultilineNew
extends CommandMultilines2<WBSDiagram> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^(.*);\\s*(\\<\\<(.+)\\>\\>)?$"));

    public CommandWBSItemMultilineNew() {
        super(CommandWBSItemMultilineNew.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH, END);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWBSItemMultilineNew.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "TYPE", "([ \t]*[*+-]+)"), new RegexOr(new RegexConcat(new RegexLeaf(1, "SHAPE_1", "(_)?"), new RegexLeaf(1, "DIRECTION_1", "([<>])?")), new RegexConcat(new RegexLeaf(1, "DIRECTION_2", "([<>])?")), new RegexLeaf(1, "SHAPE_2", "(_)?")), new RegexOr(new RegexConcat(new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR_1", "\\[(#\\w+)\\]")), new RegexOptional((IRegex)new RegexLeaf(1, "CODE_1", "\\(([%pLN_]+)\\)"))), new RegexConcat(new RegexOptional((IRegex)new RegexLeaf(1, "CODE_2", "\\(([%pLN_]+)\\)")), new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR_2", "\\[(#\\w+)\\]")))), new RegexLeaf(":"), new RegexLeaf(1, "DATA", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(WBSDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        List<String> lineLast = StringUtils.getSplit(this.getEndPattern(), lines.getLast().getString());
        lines = lines.removeStartingAndEnding(line0.get("DATA", 0), 1);
        String stereotype = lineLast.get(1);
        if (stereotype != null) {
            lines = lines.overrideLastLine(lineLast.get(0));
        }
        String type = line0.get("TYPE", 0);
        String stringColor = line0.getLazzy("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor);
        }
        String code = line0.getLazzy("CODE", 0);
        Direction dir = Direction.getWBSDirection(line0);
        return diagram.addIdea(code, backColor, diagram.getSmartLevel(type), lines.toDisplay(), Stereotype.build(stereotype), dir, IdeaShape.fromDesc(line0.getLazzy("SHAPE", 0)));
    }
}

