/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.util.CharArrayIterator;
import org.apache.lucene.analysis.util.SegmentingTokenizerBase;
import org.apache.lucene.util.AttributeFactory;

public class ThaiTokenizer
extends SegmentingTokenizerBase {
    public static final boolean DBBI_AVAILABLE;
    private static final BreakIterator proto;
    private static final BreakIterator sentenceProto;
    private final BreakIterator wordBreaker;
    private final CharArrayIterator wrapper = CharArrayIterator.newWordInstance();
    int sentenceStart;
    int sentenceEnd;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

    public ThaiTokenizer() {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
    }

    public ThaiTokenizer(AttributeFactory factory) {
        super(factory, (BreakIterator)sentenceProto.clone());
        if (!DBBI_AVAILABLE) {
            throw new UnsupportedOperationException("This JRE does not have support for Thai segmentation");
        }
        this.wordBreaker = (BreakIterator)proto.clone();
    }

    @Override
    protected void setNextSentence(int sentenceStart, int sentenceEnd) {
        this.sentenceStart = sentenceStart;
        this.sentenceEnd = sentenceEnd;
        this.wrapper.setText(this.buffer, sentenceStart, sentenceEnd - sentenceStart);
        this.wordBreaker.setText(this.wrapper);
    }

    @Override
    protected boolean incrementWord() {
        int start = this.wordBreaker.current();
        if (start == -1) {
            return false;
        }
        int end = this.wordBreaker.next();
        while (end != -1 && !Character.isLetterOrDigit(Character.codePointAt(this.buffer, this.sentenceStart + start, this.sentenceEnd))) {
            start = end;
            end = this.wordBreaker.next();
        }
        if (end == -1) {
            return false;
        }
        this.clearAttributes();
        this.termAtt.copyBuffer(this.buffer, this.sentenceStart + start, end - start);
        this.offsetAtt.setOffset(this.correctOffset(this.offset + this.sentenceStart + start), this.correctOffset(this.offset + this.sentenceStart + end));
        return true;
    }

    static {
        proto = BreakIterator.getWordInstance(new Locale.Builder().setLanguageTag("th").build());
        proto.setText("\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22");
        DBBI_AVAILABLE = proto.isBoundary(4);
        sentenceProto = BreakIterator.getSentenceInstance(Locale.ROOT);
    }
}

