\name{DerivativeImageFilter}
\alias{DerivativeImageFilter}
\title{DerivativeImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the directional derivative of an image. The directional
derivative at each pixel location is computed by convolution with a
derivative operator of user-specified order.
DerivativeImageFilter}
\details{
SetOrder specifies the order of the derivative.
SetDirection specifies the direction of the derivative with respect to
the coordinate axes of the image.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
Derivative for the procedural interface
itk::DerivativeImageFilter for the Doxygen on the original ITK class.
DerivativeImageFilter}
%C++ includes: sitkDerivativeImageFilter.h
\section{Methods}{
\describe{
\item{ DerivativeImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{unsigned int GetDirection() const:}{
The output pixel type must be signed. Standard get/set macros for
filter parameters.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{unsigned int GetOrder() const:}{
The output pixel type must be signed. Standard get/set macros for
filter parameters.
}
\item{bool GetUseImageSpacing() const:}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to compute the derivatives in
physical space; use Off to ignore the image spacing and to compute the
derivatives in isotropic voxel space. Default is On.
}
\item{Self SetDirection(unsigned int Direction):}{
The output pixel type must be signed. Standard get/set macros for
filter parameters.
}
\item{Self SetOrder(unsigned int Order):}{
The output pixel type must be signed. Standard get/set macros for
filter parameters.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to compute the derivatives in
physical space; use Off to ignore the image spacing and to compute the
derivatives in isotropic voxel space. Default is On.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~DerivativeImageFilter():}{
Destructor
}
}
}
