/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPReporter;
import com.sun.media.rtp.RTPSinkStream;
import com.sun.media.rtp.RTPTransStats;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.TrueRandom;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;

public class SendSSRCInfo
extends SSRCInfo
implements SenderReport,
SendStream {
    boolean inited = false;
    private static final int PACKET_SIZE = 4000;
    protected int packetsize = 0;
    protected Format myformat = null;
    protected long totalSamples = 0L;
    protected long lastSeq = -1L;
    protected long lastBufSeq = -1L;
    protected RTPTransStats stats = null;
    protected RTCPReporter rtcprep = null;
    static AudioFormat dviAudio = new AudioFormat("dvi/rtp");
    static AudioFormat gsmAudio = new AudioFormat("gsm/rtp");
    static AudioFormat g723Audio = new AudioFormat("g723/rtp");
    static AudioFormat ulawAudio = new AudioFormat("ULAW/rtp");
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");

    public SendSSRCInfo(SSRCCache cache, int ssrc) {
        super(cache, ssrc);
        this.maxseq = this.baseseq = (int)TrueRandom.rand();
        this.lasttimestamp = (int)TrueRandom.rand();
        this.sender = true;
        this.wassender = true;
        this.sinkstream = new RTPSinkStream();
        this.stats = new RTPTransStats();
    }

    public SendSSRCInfo(SSRCInfo info) {
        super(info);
        this.maxseq = this.baseseq = (int)TrueRandom.rand();
        this.lasttimestamp = (int)TrueRandom.rand();
        this.sender = true;
        this.wassender = true;
        this.sinkstream = new RTPSinkStream();
        this.stats = new RTPTransStats();
    }

    public long getTimeStamp(Buffer b) {
        if (b.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(b.getFormat())) {
                if (b.getTimeStamp() >= 0L) {
                    return b.getTimeStamp() * 90L / 1000000L;
                }
                return System.currentTimeMillis() * 90L;
            }
            this.totalSamples += (long)this.calculateSampleCount(b);
            return this.totalSamples;
        }
        if (b.getFormat() instanceof VideoFormat) {
            if (b.getTimeStamp() >= 0L) {
                return b.getTimeStamp() * 90L / 1000000L;
            }
            return System.currentTimeMillis() * 90L;
        }
        return b.getTimeStamp();
    }

    private int calculateSampleCount(Buffer b) {
        AudioFormat f = (AudioFormat)b.getFormat();
        if (f == null) {
            return -1;
        }
        long t = f.computeDuration(b.getLength());
        if (t == -1L) {
            return -1;
        }
        if (f.getSampleRate() != -1.0) {
            return (int)((double)t * f.getSampleRate() / 1.0E9);
        }
        if (f.getFrameRate() != -1.0) {
            return (int)((double)t * f.getFrameRate() / 1.0E9);
        }
        return -1;
    }

    public long getSequenceNumber(Buffer b) {
        long seq = b.getSequenceNumber();
        if (this.lastSeq == -1L) {
            this.lastSeq = (long)((double)System.currentTimeMillis() * Math.random());
            this.lastBufSeq = seq;
            return this.lastSeq;
        }
        this.lastSeq = seq - this.lastBufSeq > 1L ? (this.lastSeq += seq - this.lastBufSeq) : ++this.lastSeq;
        this.lastBufSeq = seq;
        return this.lastSeq;
    }

    protected void setFormat(Format fmt) {
        this.myformat = fmt;
        if (this.sinkstream != null) {
            int rate = 0;
            if (fmt instanceof AudioFormat) {
                if (ulawAudio.matches(fmt) || dviAudio.matches(fmt) || mpegAudio.matches(fmt)) {
                    rate = (int)((AudioFormat)fmt).getSampleRate() * ((AudioFormat)fmt).getSampleSizeInBits();
                } else if (gsmAudio.matches(fmt)) {
                    rate = 13200;
                } else if (g723Audio.matches(fmt)) {
                    rate = 6300;
                }
                this.sinkstream.rate = rate;
            }
        } else {
            System.err.println("RTPSinkStream is NULL");
        }
    }

    public long getSenderPacketCount() {
        return this.lastSRpacketcount;
    }

    public long getSenderByteCount() {
        return this.lastSRoctetcount;
    }

    public long getNTPTimeStampMSW() {
        return this.lastSRntptimestamp >> 32;
    }

    public long getNTPTimeStampLSW() {
        return this.lastSRntptimestamp;
    }

    public long getRTPTimeStamp() {
        return this.lastSRrtptimestamp;
    }

    public Feedback getSenderFeedback() {
        SSRCCache cache = this.getSSRCCache();
        Report report = null;
        Vector reports = null;
        Vector feedback = null;
        Feedback reportblk = null;
        try {
            LocalParticipant localpartc = cache.sm.getLocalParticipant();
            reports = localpartc.getReports();
            int i = 0;
            while (i < reports.size()) {
                report = (Report)reports.elementAt(i);
                feedback = report.getFeedbackReports();
                int j = 0;
                while (j < feedback.size()) {
                    reportblk = (Feedback)feedback.elementAt(j);
                    long ssrc = reportblk.getSSRC();
                    if (ssrc == this.getSSRC()) {
                        return reportblk;
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public RTPStream getStream() {
        return this;
    }

    public Participant getParticipant() {
        SSRCCache cache = this.getSSRCCache();
        if (this.sourceInfo instanceof LocalParticipant && cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public void setSourceDescription(SourceDescription[] userdesclist) {
        super.setSourceDescription(userdesclist);
    }

    public void close() {
        try {
            this.stop();
        }
        catch (IOException e) {
            // empty catch block
        }
        SSRCCache cache = this.getSSRCCache();
        cache.sm.removeSendStream(this);
    }

    public SenderReport getSenderReport() {
        SSRCCache cache = this.getSSRCCache();
        Report report = null;
        Vector reports = null;
        Vector feedback = null;
        Feedback reportblk = null;
        try {
            LocalParticipant localpartc = cache.sm.getLocalParticipant();
            reports = localpartc.getReports();
            int i = 0;
            while (i < reports.size()) {
                report = (Report)reports.elementAt(i);
                feedback = report.getFeedbackReports();
                int j = 0;
                while (j < feedback.size()) {
                    reportblk = (Feedback)feedback.elementAt(j);
                    long ssrc = reportblk.getSSRC();
                    if (ssrc == this.getSSRC()) {
                        return (SenderReport)report;
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public DataSource getDataSource() {
        return this.pds;
    }

    public void stop() throws IOException {
        if (this.pds != null) {
            this.pds.stop();
        }
        if (this.sinkstream != null) {
            this.sinkstream.stop();
        }
    }

    public void start() throws IOException {
        if (!this.inited) {
            this.inited = true;
            this.probation = 0;
            this.initsource((int)TrueRandom.rand());
            this.lasttimestamp = (int)TrueRandom.rand();
        }
        if (this.pds != null) {
            this.pds.start();
        }
        if (this.sinkstream != null) {
            this.sinkstream.start();
        }
    }

    protected void createDS() {
    }

    public int setBitRate(int rate) {
        if (this.sinkstream != null) {
            this.sinkstream.rate = rate;
        }
        return rate;
    }

    public TransmissionStats getSourceTransmissionStats() {
        return this.stats;
    }
}

