/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.probsoln;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnData;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnDatabase;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnSty;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;

public class LoadRandomExcept
extends ControlSequence {
    private ProbSolnSty sty;

    public LoadRandomExcept(ProbSolnSty probSolnSty) {
        this("loadrandomexcept", probSolnSty);
    }

    public LoadRandomExcept(String string, ProbSolnSty probSolnSty) {
        super(string);
        this.sty = probSolnSty;
    }

    @Override
    public Object clone() {
        return new LoadRandomExcept(this.getName(), this.sty);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string = this.popOptLabelString(teXParser, teXObjectList);
        if (string == null) {
            string = "default";
        }
        int n = this.popInt(teXParser, teXObjectList);
        TeXObject teXObject = this.popArgExpandFully(teXParser, teXObjectList);
        TeXObject teXObject2 = this.popArgExpandFully(teXParser, teXObjectList);
        teXParser.startGroup();
        ProbSolnDatabase probSolnDatabase = this.sty.getTmpDatabase();
        teXParser.putControlSequence(true, new GenericCommand(true, "prob@currentdb", null, teXParser.getListener().createString(probSolnDatabase.getName())));
        CsvList csvList = CsvList.getList(teXParser, teXObject);
        int n2 = csvList.size();
        for (int i = 0; i < n2; ++i) {
            teXParser.getListener().input(new TeXPath(teXParser, csvList.getValue(i).toString(teXParser)), teXObjectList);
        }
        teXParser.putControlSequence(true, new GenericCommand(true, "prob@currentdb", null, teXParser.getListener().createString(string)));
        ProbSolnDatabase probSolnDatabase2 = this.sty.isDatabaseDefined(string) ? this.sty.getDatabase(string) : this.sty.addDatabase(string);
        if (probSolnDatabase2.size() > 0) {
            csvList = CsvList.getList(teXParser, teXObject2);
            n2 = csvList.size();
            Vector<String> vector = new Vector<String>(n2);
            for (int i = 0; i < n2; ++i) {
                vector.add(csvList.getValue(i).toString(teXParser));
            }
            Vector<String> vector2 = new Vector<String>(probSolnDatabase2.size());
            for (String string2 : probSolnDatabase2.keySet()) {
                if (vector.contains(string2)) continue;
                vector2.add(string2);
            }
            Collections.shuffle(vector2, this.sty.getRandom());
            int n3 = Integer.min(probSolnDatabase2.size(), n);
            for (int i = 0; i < n3; ++i) {
                String string3 = (String)vector2.get(i);
                ProbSolnData probSolnData = (ProbSolnData)probSolnDatabase.get(string3);
                if (probSolnData == null) continue;
                probSolnDatabase2.put(probSolnData.getName(), probSolnData);
            }
        }
        this.sty.clearTmpDatabase();
        teXParser.endGroup();
    }
}

